# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
A classical problem of summing up linked lists with a little variation that here the lists are not given reversed.

# Approach
<!-- Describe your approach to solving the problem. -->
Various approach are proposed to solve this :
- Make two arrays; store numbers of lists in them respectively ; add arrays from their last indices 
- or
- Make two stack and...same
- ...etc

I have used the concept of Deque ; in this you can take out elements from both start and end side.

- Created two deques, stored both list's numbers in them separately
- Add numbers from the last indices ( used carry if sum > 10) by using deque advantage ( pollLast).
- Simultaneously keep adding the sum to a node first(null)
- Next digit that came after adding will be in left side so keep updating that in now.next = first

( In start of attemp I used another deque for storing sum and then storing it in linked list to return ; but as this was waste of time n space so I just commented out this in code. )

Have a look at the code and if you still have any confusion then please let me know in the comments. :)
Keep Solving. :)



# Complexity
- Time complexity :  $$O( l1 + l2 )$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity :  $$O( l1 + l2 )$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->
$$ l1 $$ & $$ l2$$ are the sizes of linked lists.

# Code
```
/**
 * Definition for singly-linked list.
 * public class ListNode {
 *     int val;
 *     ListNode next;
 *     ListNode() {}
 *     ListNode(int val) { this.val = val; }
 *     ListNode(int val, ListNode next) { this.val = val; this.next = next; }
 * }
 */
class Solution {
    public ListNode addTwoNumbers(ListNode l1, ListNode l2) {
        Deque<Integer> r1 = new ArrayDeque<>();
            while( l1 != null){
                r1.add(l1.val);
                l1 = l1.next;
            }
            //System.out.println( r1.toString());
            Deque<Integer> r2 = new ArrayDeque<>();
            while( l2 != null){
                r2.add(l2.val);
                l2 = l2.next;
            }
            //System.out.println( r2.toString());

            ListNode first = null;
            //Deque<Integer> sum = new ArrayDeque<>();
            int carry = 0;
            while( r1.peekLast() != null || r2.peekLast() != null || carry != 0){
                int t = carry;
                if( r1.peekLast() != null){
                    t += r1.pollLast();
                }
                if( r2.peekLast() != null){
                    t += r2.pollLast();
                }
                //sum.addFirst( t % 10);
                ListNode now = new ListNode( t % 10);
                now.next = first;
                first = now;
                //System.out.print( t%10 + " ");
                carry = t / 10;
            }
            //System.out.print( sum.toString());
            
            return first;
        
    }
}
```